<?php 
/**
 * F8EOZ fonctions et variables
 * version 09/12/2011
 * Modification: ajout d'un setup, prise en compte des fichiers de traduction
 */
// Ce code d'initialisation est toujours excut. 

// Set path des fonctions spcifiques
$setup_path = TEMPLATEPATH . '/functions/setup/'; // setup path
$content_path = TEMPLATEPATH . '/functions/content/'; // setup content
//Charger les fonctions spcifiques
require_once ($setup_path . 'theme-setup.php');	// setup theme
require_once ($content_path . 'theme-content.php');	// setup theme

// Path des fichiers de traduction
add_action('after_setup_theme', 'traduction_setup');
function traduction_setup(){
	// Prparation du rpertoire et du fichier de traduction
	load_theme_textdomain( 'f8eoz', TEMPLATEPATH . '/languages' ); // fixer le nom du domaine
	$locale = get_locale(); // Notre langue fr et notre pays FR = fr_FR
	$locale_file = TEMPLATEPATH . "/languages/$locale.php";
	if ( is_readable( $locale_file ) ) require_once( $locale_file );	
	// The .mo files must use language-only filenames, like languages/de_DE.mo in your theme directory
} // end setup

// paramtres pour du sidebardynamique
if (function_exists('register_sidebar') )
	// est utilis quand on ajoute un widget
	register_sidebar(array(
		'before_widget' => '<li id="%1$s" class="widget %2$s">',
		'after_widget' => '</li>',
		'before_title' => '<h2 class="widgettitle">',
		'after_title' => '</h2>',
	)
); // ici tous les paramtres ont la valeur par dfaut

/* Si la fonction wp_list_comments() existe, nous sommes en WordPress 2.7, 
la fonction comments_template() chargera le fichier comments.php (comportement par dfaut).
Si wp_list_comments() nexiste pas, alors la fonction chargera le fichier legacy-comments.php. */  
add_filter('comments_template', 'legacy_comments');

// ================================================
// fin du code d'initialisation
// ================================================
	
function legacy_comments($file) {
	if(!function_exists('wp_list_comments')) $file = TEMPLATEPATH . '/legacy.comments.php';
	return $file;
}

// Produces an avatar image with the hCard-compliant photo class
function commenter_link() {
        $commenter = get_comment_author_link();
        if ( ereg( '<a[^>]* class=[^>]+>', $commenter ) ) {
                $commenter = ereg_replace( '(<a[^>]* class=[\'"]?)', '\\1url ' , $commenter );
        } else {
                $commenter = ereg_replace( '(<a )/', '\\1class="url "' , $commenter );
        }
        $avatar_email = get_comment_author_email();
        $avatar = str_replace( "class='avatar", "class='photo avatar", get_avatar( $avatar_email, 80 ) );
        echo $avatar . ' <span class="fn n">' . $commenter . '</span>';
} // end commenter_link

// Une itration de la boucle de traitement des commentaires wp_list_comments
// Affiche le commentaire, ping, trackback, ses mta-donnes, la possibilt de modifier et d'y rpondre
// $comment = commentaire affich
// $args contient les arguments par dfaut de la fonction wp_list_comments
// $depth = niveau de profondeur du commentaire affich = 1  n
// Voir tableau de bord, options de discussion Enable threaded (nested) comments
function custom_comments($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	$GLOBALS['comment_depth'] = $depth; /* Voir tableau de bord options de discusiion Enable threaded (nested) comments */
	?>
	<li id="comment-<?php comment_ID() ?>" <?php comment_class() ?>>
		<div>
			<span class="comment-author vcard">
				<!-- pour afficher l'avatar enlever le commentaire -->
				<!--?php commenter_link() ?-->
				<cite class="fn"><?php comment_author_link() ?></cite> &middot;		
			</span>
			<span class="comment-meta">
				<!--La fonction __() (2 underscores) traduit une chane de caractres en utilisant le gettext PHP.
				Le 1er paramtre est le string  traduire, 
				le second, appel le domain, dit  WordPress o se trouve la traduction.
				Il est ainsi possible de fournir un fichier.mo et .po qui contient la traduction du thme-->
				<?php printf(__('<a href="%3$s" title="Lien vers ce commentaire">%1$s &agrave; %2$s </a>', 'f8eoz'),
								get_comment_date('l j F Y'),
								get_comment_time('H:m:s'),
								'#comment-' . get_comment_ID() ); ?> &nbsp;&nbsp;
				<?php edit_comment_link(__("(Modifier)", 'f8eoz'), ''); ?>
			</span>
		</div>
		<div>
			<?php if ($comment->comment_approved == '0') :?>
				<span class="comment-unapproved">
					<?php _e("En attente de mod&eacute;ration.", 'f8eoz'); ?>
				</span>
			<?php else : comment_text(); // le commentaire est affich s'il est approuv?>
			<?php endif ?>	<!-- fin comment_approved -->
        </div>
		<div class="reply">
			<?php // echo the comment reply link
            if($args['type'] == 'all' || get_comment_type() == 'comment') :
                    comment_reply_link(array_merge($args, array(
                            'reply_text' => __('R&eacute;pondre','f8eoz'), 
                            'login_text' => __('Connexion pour r&eacute;pondre.','f8eoz'),
                            'depth' => $depth,
                            'before' => '<div class="comment-reply-link">', 
                            'after' => '</div>'
                                )));
            endif; ?>
		</div>	
	</li><!--end li id="comment-"-->
<?php } // end custom_comments

// Custom callback to list pings
function custom_pings($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
    ?>
	<li id="comment-<?php comment_ID() ?>" <?php comment_class() ?>>
		<div>
			<span class="comment-meta">
				<?php printf(__('Pings %1$s on %2$s at %3$s', 'f8eoz'),
							get_comment_author_link(),
							get_comment_date('l j F Y'),
							get_comment_time('H:m:s') );
							edit_comment_link(__("(Modifier)", 'f8eoz'), '') ?>
			</span>
		</div>
		<div>
			<?php if ($comment->comment_approved == '0') :?>
				<span class="comment-unapproved">
					<?php _e("En attente de mod&eacute;ration.", 'f8eoz'); ?>
				</span>
			<?php else : comment_text(); // le commentaire est affich s'il est approuv?>
			<?php endif ?>	<!-- fin comment_approved -->
		</div>
	</li><!--end li id="comment-"-->
<?php } // end custom_pings ?>
