<?php // Do not delete these lines
/* Before a comment appears, the comment author must fill out his/her name and email. 
1 : Yes (default) 
0 : No 
Data type: Integer */
$requireoption = get_option('require_name_email'); // Checks if fields are required.

if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
die ( __('Veuillez ne pas passer directement par cette page. Merci!', 'f8eoz') );

if (!empty($post->post_password)) { // if there's a password
	if ($_COOKIE['wp-postpass_' . COOKIEHASH] != $post->post_password) {  // and it doesn't match the cookie
		?>
		<p class="nocomments"><?php _e('La publication est prot&eacute;g&eacute;e. Etrer le mot de passe pour voir les commentaires.', 'f8eoz'); ?></p>
		<?php
		return;
	}
}

/* This variable is for alternating comment background */
$oddcomment = 'even';
?>

<!-- You can start editing here. -->

<div id="comments">
	<?php if ($comments) : ?>
		<h3><?php comments_number(__('Aucun commentaire', 'f8eoz'), __('1 Commentaire', 'f8eoz'), __('% Commentaires', 'f8eoz') );?></h3>

		<ol class="commentlist">
			<?php foreach ($comments as $comment) : ?>
				<li class="comment <?php echo $oddcomment; ?>" id="comment-<?php comment_ID() ?>">
					<div id="div-comment-<?php comment_ID() ?>">
					<div class="comment-author">
					<?php // Gravatar code
					if(function_exists('get_avatar')) echo get_avatar( $comment, 48 );
					?>
					<cite><?php comment_author_link() ?>:<cite></div>
					<?php comment_text() ?>
					<?php if ($comment->comment_approved == '0') : ?>
						<em>(<?php _e("En attente de mod&eacute;ration.", 'f8eoz'); ?>)</em>
					<?php endif; ?>
					<div class="comment-meta"><a href="#comment-<?php comment_ID() ?>" title=""><?php comment_date(get_option('date_format')) ?>, <?php comment_time(get_option('time_format')) ?></a>
					<?php edit_comment_link(__('Modifier', 'f8eoz'),'&nbsp;|&nbsp;&nbsp;',''); ?></div></div>
				</li>
				<?php
				/* Changes every other comment to a different class */
				$oddcomment = ( $oddcomment == 'odd' ) ? 'even' : 'odd';
				?>
			<?php endforeach; /* end for each comment */ ?>
		</ol>

	<?php else : // this is displayed if there are no comments so far ?>
		<?php if ('open' == $post->comment_status) : ?>
			<!-- If comments are open, but there are no comments. -->
		<?php else : // comments are closed ?>
			<!-- commentaires ferms-->
			<p class="nocomments"><?php _e('Commentaires ferm&eacute;s.', 'f8eoz'); ?></p>
		<?php endif; ?>
	<?php endif; ?>

	<?php if ('open' == $post->comment_status) : ?>

		<h3 id="respond"><?php _e('Publier un commentaire', 'f8eoz') ?></h3>

		<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
			<p><?php _e('Vous devez &ecirc;tre', 'f8eoz'); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>"><?php _e('connect&eacute;', 'f8eoz'); ?></a> <?php _e('pour publier un commentaire.', 'f8eoz'); ?></p>
		<?php else : ?>
			<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
				<?php if ( $user_ID ) : ?>
					<p><?php _e('Connect&eacute; comme', 'f8eoz') ?> 
					<a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>. 
					<a href="<?php echo get_option('siteurl'); ?>/wp-login.php?action=logout" title="<?php _e('Logout', 'f8eoz'); ?>"><?php _e('D&eacute;connexion &raquo;', 'f8eoz'); ?> &raquo;</a>
					</p>
				<?php else : ?>
					<p><input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="22" tabindex="1" />
						<label for="author"><small><?php _e('Nom', 'f8eoz'); ?> <?php if ($requireoption) _e('(requis)', 'f8eoz'); ?></small></label>
					</p>
					<p><input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" />
						<label for="email"><small><?php _e('Mail (non publi&eacute;)', 'f8eoz'); ?> <?php if ($requireoption) _e('(requis)', 'f8eoz'); ?></small></label>
					</p>
					<p><input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="22" tabindex="3" />
						<label for="url"><small><?php _e('Site web', 'f8eoz'); ?></small></label>
					</p>
				<?php endif; ?>
				<!--<p><small><strong>XHTML:</strong> You can use these tags: <?php echo allowed_tags(); ?></small></p>-->
				<p><textarea name="comment" id="comment" rows="10" cols="100%" tabindex="4"></textarea></p>

				<p><input name="submit" type="submit" id="submit" tabindex="5" value="<?php _e('Valider', 'f8eoz'); ?>" />
					<input type="hidden" name="comment_post_ID" value="<?php echo $id; ?>" />
				</p>
				<?php do_action('comment_form', $post->ID); ?>
			</form>

		<?php endif; // If registration required and not logged in ?>
	<?php endif; // if you delete this the sky will fall on your head ?>
</div>

