<?php
    /* Before a comment appears, the comment author must fill out his/her name and email. 
    1 : Yes (default) 
    0 : No 
    Data type: Integer */
    $requireoption = get_option('require_name_email'); // Checks if fields are required.
	
// Do not delete these lines
if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
    die ( __('Veuillez ne pas passer directement par cette page. Merci!', 'f8eoz') );

if ( post_password_required() ) { ?>
	<p class="nocomments"><?php _e('La publication est prot&eacute;g&eacute;e. Etrer le mot de passe pour voir les commentaires.', 'f8eoz'); ?></p>
	<?php return;
}
?>

<div id="comments">
	<?php 
	/* S'il y a des commentaires les afficher! */                                             
	if ( have_comments() ) : 
		// Compte le nombre de commentaires et de pings (pingback + trackback)
		$ping_count = $comment_count = 0;  // init compteur de pings et de commentaires
		// compte les commentaires et les pings
		foreach ( $comments as $comment ) 
			get_comment_type() == "comment" ? ++$comment_count : ++$ping_count;
		// fin de boucle foreach
		
		/* S'il y a des commentaires, les afficher */ 
		$comments_by_type = &separate_comments($comments); // ncessaire sinon le if suivant ne marche pas!
		if ( ! empty($comments_by_type['comment']) ) : ?>
			 <!-- affiche le nombre de commentaires -->
			<h3><?php printf($comment_count > 1 ? __('%d Commentaires', 'f8eoz') : 
					__('1 Commentaire', 'f8eoz'), $comment_count) ?></h3>
			
			<div style="clear:both"></div>
			<!-- Une liste classe des commentaires, voir custom_comments() dans functions.php -->                         
			<ol class="commentlist">
				<?php wp_list_comments('type=comment&callback=custom_comments'); ?>
			</ol>
			<?php
			/* S'il y a trop de commentaire placer les liens de navigation  */                                      
			$total_pages = get_comment_pages_count(); 
			if ( $total_pages > 1 ) : ?>
				<div class="navigation" style="clear:both">
					<div class="alignleft"><?php previous_comments_link(__('&laquo; Commentaires plus anciens', 'f8eoz')) ?></div>
					<div class="alignright"><?php next_comments_link(__('commentaires plus r&eacute;cents &raquo;', 'f8eoz')) ?></div>
				</div>
			<?php endif; ?>       
			<div style="clear:both"></div>
		
		<?php endif; // ! empty($comments_by_type['comment']) ) ?>

		<?php /* S'il y a des rtro-liens (trackbacks, pings), les afficher */
		if ( ! empty($comments_by_type['pings']) ) : ?>
			<h3><?php printf($ping_count > 1 ? __('<span>%d</span> R&eacute;troliens', 'f8eoz') :
				__('<span>1</span> R&eacute;troliens', 'f8eoz'), $ping_count) ?></h3>
				<!-- Une liste classe des retro-liens, voir custom_pings() dans functions.php -->                         
			<ol class="commentlist">
				<?php wp_list_comments('type=pings&callback=custom_pings'); ?>
			</ol> 
			<div style="clear:both"></div>		
		<?php endif; /* if ( $ping_count ) */?>

	<?php else : // pas de commentaires ?>
		<?php if ('open' == $post->comment_status) : ?>
			<!-- commentaires ouverts -->
		 <?php else : // comments are closed ?>
			<!-- commentaires ferms-->
			<p class="nocomments"><?php _e('Commentaires ferm&eacute;s.', 'f8eoz'); ?></p>
		<?php endif; /* if ( open ) */ ?>

	<?php endif; // have_comments() ?>

	<?php
	/* Si les commentaires sont ouvert, fabriquer la grille de rponse */ 
	if ( 'open' == $post->comment_status ) : ?>
		<div id="respond">
			<b><?php comment_form_title( __('Publier un commentaire', 'f8eoz'), __('Publier un commentaire &agrave; %s', 'f8eoz') ); ?>
			</b>&nbsp&nbsp&nbsp<?php cancel_comment_reply_link( __('(Annuler)', 'f8eoz')); ?>
				
			<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
				<p><?php _e('Vous devez &ecirc;tre', 'f8eoz'); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>"><?php _e('connect&eacute;', 'f8eoz'); ?></a> <?php _e('pour publier un commentaire.', 'f8eoz'); ?></p>
			<?php else : ?>

				<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

					<?php if ( $user_ID ) : ?>
						<p><?php _e('Connect&eacute; comme', 'f8eoz'); ?> 
						<a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>
						| <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e('Logout', 'f8eoz'); ?>"><?php _e('D&eacute;connexion &raquo;', 'f8eoz'); ?></a>
						</p>
					<?php else : ?>
						<p><input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="22" tabindex="1" />
							<label for="author"><small><?php _e('Nom', 'f8eoz'); ?> <?php if ($requireoption) _e('(requis)', 'f8eoz'); ?></small></label>
						</p>
						<p><input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" />
							<label for="email"><small><?php _e('Mail (non publi&eacute;)', 'f8eoz'); ?> <?php if ($requireoption) _e('(requis)', 'f8eoz'); ?></small></label>
						</p>
						<p><input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="22" tabindex="3" />
							<label for="url"><small><?php _e('Site web', 'f8eoz'); ?></small></label>
						</p>
					<?php endif /* if ( $user_ID ) */ ?>
					<!--<p><small><strong>XHTML:</strong> You can use these tags: <code><?php echo allowed_tags(); ?></code></small></p>-->

					<p><textarea name="comment" id="comment" cols="100%" rows="10" tabindex="4"></textarea></p>
					<p><input name="submit" type="submit" id="submit" tabindex="5" value="<?php _e('Valider', 'f8eoz'); ?>" />
						<?php comment_id_fields(); ?> <!--Gnre 2 champs cachs: comment_post_ID et comment_parent -->
					</p>
					<?php do_action('comment_form', $post->ID); ?>

				</form><!-- #commentform --> 
		
			<?php endif; // If registration required and not logged in ?>
		</div><!-- #respond -->
	<?php endif; // if ( 'open' == $post->comment_status ) ?>
</div><!-- #comments -->

