﻿using System;

namespace chargePIC
{
    class uartEventArgs : EventArgs
    {
        public byte[] Buffer { get; set; }
        public object[] Obj { get; set; }
        public string[] Str { get; set; }
        public Device Dev { get; set; }
        public int Max { get; internal set; }
        public int Min { get; internal set; }
        public int Step { get; internal set; }
        public int Ptr { get; internal set; }
        public bool ProtectedArea { get; internal set; }
        public bool EEPROM { get; internal set; }

        public uartEventArgs() { }
        public uartEventArgs(string[] s) { this.Str = s; }
        public uartEventArgs(byte[] b) { this.Buffer = b; }
        public uartEventArgs(int i) { this.Ptr = i; }
        public uartEventArgs(int i, string[] s) { this.Ptr = i; this.Str = s; }
    }
}