﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace chargePIC
{
    public static class MyExtensions
    {

        public static int HexToInt(this String str)
        {
            byte[] b = System.Text.ASCIIEncoding.Default.GetBytes(str);
            return b.HexToInt();
        }

        public static int HexToInt(this byte[] b)
        {
            if (b.Length == 4)
                return HexToInt(b[0], b[1], b[2], b[3]);
            if (b.Length == 3)
                return HexToInt((byte)'0', b[0], b[1], b[2]);
            if (b.Length == 2)
                return HexToInt((byte)'0', (byte)'0', b[0], b[1]);
            if (b.Length == 1)
                return HexToInt((byte)'0', (byte)'0', (byte)'0', b[0]);
            return 0;
        }

        /// <summary> Convert Char '0'...'9', 'A'...'F' to 0...15 </summary>
        public static int HexToInt(byte hexChar)
        {
            char c = Char.ToUpper((char)hexChar);
            return (int)c < (int)'A' ? ((int)c - (int)'0') :
                10 + ((int)c - (int)'A');
        }

        /// <summary> Convert 2 Char '0'...'9', 'A'...'F' to 0...255 </summary>
        public static int HexToInt(byte hexChar3, byte hexChar2, byte hexChar1, byte hexChar0)
        {
            return HexToInt(hexChar3) * 16 * 16 * 16 + HexToInt(hexChar2) * 16 * 16
                 + HexToInt(hexChar1) * 16 + HexToInt(hexChar0);
        }

    }
}
