﻿using chargePIC.Properties;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace chargePIC
{
    public partial class BaudRateCalculForm : Form
    {
        internal double[] DesirBaud = { 1200, 2400, 4800, 9600, 14400, 19200, 38400, 57600, 115200, 230400 };
        internal double[] BaudError = { 0, 0 };
        internal int[] spbrg = { 0, 0 };
        internal bool altLine = false;

        private Settings settings = Settings.Default;

        public BaudRateCalculForm()
        {
            settings.Reload();

            InitializeComponent();

            // Restore the users settings
            InitializeControlValues();
        }

        private void ViewBaudRate(ListViewItem lvi)
        {
            BaudRateListView.Invoke(new EventHandler(delegate
            {
                lvi.UseItemStyleForSubItems = false; // for changing color of list view cell
                foreach (ListViewItem.ListViewSubItem si in lvi.SubItems)
                    if (altLine)
                        si.ForeColor = Color.Green; // color all columns
                BaudRateListView.Items.Add(lvi);
                altLine = !altLine;
            }));
        }

        int BaudErrorCalcul(double baud, int BRGH, double minError, double maxError)
        {
            int retval, i;

            retval = -1;
            for (i = 0; i < DesirBaud.Length; i++)
            {

                if ((baud >= (DesirBaud[i] * minError)) && (baud <= (DesirBaud[i] * maxError)))
                {
                    BaudError[BRGH] = ((baud - DesirBaud[i]) / DesirBaud[i]) * 100;
                    retval = i;
                }
            }
            return (retval);
        }

        private void BaudRateCalculate(float Fosc, double minError, double maxError)
        {
            int SPBRG;
            double[] CalcBaud = { 0, 0 };

            for (SPBRG = 255; SPBRG != 0; SPBRG--)
            {
                CalcBaud[0] = Fosc / ((SPBRG + 1.0) * 64.0);
                spbrg[0] = BaudErrorCalcul(CalcBaud[0], 0, minError, maxError);

                CalcBaud[1] = Fosc / ((SPBRG + 1.0) * 16.0);
                spbrg[1] = BaudErrorCalcul(CalcBaud[1], 1, minError, maxError);
                if ((spbrg[0] >= 0) || (spbrg[1] >= 0))
                {
                    ListViewItem lvi = new ListViewItem(string.Format("{0:000}", SPBRG));

                    if (spbrg[0] >= 0)
                    {
                        lvi.SubItems.Add(string.Format("{0:0.00}", CalcBaud[0]));
                        lvi.SubItems.Add(string.Format("{0:0.00}", BaudError[0]));
                        lvi.SubItems.Add(string.Format("{0:0}", DesirBaud[spbrg[0]]));
                    }
                    else
                    {
                        lvi.SubItems.Add("");
                        lvi.SubItems.Add("");
                        lvi.SubItems.Add("");
                    }
                    if (spbrg[1] >= 0)
                    {
                        lvi.SubItems.Add(string.Format("{0:0.00}", CalcBaud[1]));
                        lvi.SubItems.Add(string.Format("{0:0.00}", BaudError[1]));
                        lvi.SubItems.Add(string.Format("{0:0}", DesirBaud[spbrg[1]]));
                    }
                    else
                    {
                        lvi.SubItems.Add("");
                        lvi.SubItems.Add("");
                    }
                    ViewBaudRate(lvi);
                }
            }
        }

        private void InitializeControlValues()
        {
            //float f = Form1.Osc;

            //FoscTextBox.Text = Form1.getOscillatorFrequency().ToString();
            FoscTextBox.Text = settings.OscillatorFrequency.ToString("0");
            BaudErrorNumericUpDown.Value = settings.BaudError;
            SaveChangesCheckBox.Checked = settings.SaveChangesBaud;
        }

        private void BaudRateCalculForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (SaveChangesCheckBox.Checked)
            {
                settings.OscillatorFrequency = float.Parse(FoscTextBox.Text);
                settings.BaudError = BaudErrorNumericUpDown.Value;
            }
            settings.SaveChangesBaud = SaveChangesCheckBox.Checked;
            settings.Save();

        }

        private void FoscTextBox_KeyPress(object sender, KeyPressEventArgs e)
        {
            char keyChar;
            keyChar = e.KeyChar;

            if (!(Char.IsDigit(keyChar) // 0 - 9
               || keyChar == 8  // backspace
               || keyChar == 13  // enter
               ))
            {
                //  Do not display the keystroke
                e.Handled = true;
            }

        }

        private void calculateButton_Click(object sender, EventArgs e)
        {
            double[] minError = { 0, 0.99, 0.98, 0.97, 0.96 };
            double[] maxError = { 0, 1.01, 1.02, 1.03, 1.04 };

            if (FoscTextBox.Text.Trim() != "")
            {
                BaudRateListView.Items.Clear();
                BaudRateCalculate(float.Parse(FoscTextBox.Text), minError[(int)BaudErrorNumericUpDown.Value], maxError[(int)BaudErrorNumericUpDown.Value]);
            }

        }
    }
}
