/*******************************************************************************
; File Name    	: led16F88_test1.c
; Version      	: 1.0
; Title:       	: BLINK LED TEST and USART Bootloader
; Author		: F8EOZ Bernard DECAESTECKER http://f8eoz.com
; MCU			: Written and Tested on Microchip PIC 16F88 Microcontroller
; Compiler     	: HI_TECH ANSI C Compiler V9.83
; IDE          	: Microchip MPLAB IDE v8.92
; Programmer   	: Home made
; Last Updated 	: 17 December 2015
; *******************************************************************
; Hardware:     
;  Tested with PIC16F88 at 4Mhz  internal oscillator.       
;  USART use pin 8 as RX (RB2) 
;  USART use pin 11 as TX (RB5) 
; *******************************************************************
*/

#include	<pic.h>
#include	<htc.h>


//	__CONFIG    _CONFIG1, _INTRC_IO  & _CP_OFF & _CCP1_RB0 & _DEBUG_OFF & _WRT_PROTECT_OFF & _CPD_OFF & _LVP_OFF & _BODEN_ON & _MCLR_ON & _PWRTE_ON & _WDT_OFF & _INTRC_IO
//	__CONFIG    _CONFIG2, _IESO_OFF & _FCMEN_OFF

#if defined(_16F88) || defined(_16F87)
	//1st: CONFIG1
	__CONFIG (FOSC_INTOSCCLK & CP_OFF & CCPMX_RB0 & DEBUG_OFF & WRT_OFF & CPD_OFF & LVP_OFF & BOREN_ON & MCLRE_ON & PWRTE_ON & WDTE_OFF & FOSC_INTOSCIO & IESO_OFF & FCMEN_OFF);
	//next: CONFIG2
	__CONFIG (IESO_OFF & FCMEN_OFF);
#else
	#error Must be compiled for 16F88, or 16F87
#endif

#ifndef _XTAL_FREQ
 // Unless already defined assume 4MHz system frequency
 // This definition is required to calibrate __delay_us() and __delay_ms()
	#define _XTAL_FREQ 4000000
#endif
#define LED	RA2	//bit 2 of PORTA
#define TRISLED	TRISA2	//bit 2 of PORTA

void interrupt tc_int(void) 	
{ 	
        return; 	
}	

void main()
{
	TRISLED = 0; //Output
	PORTA = 0b00000000;	// clrf	PORTA
	PORTB = 0b00000000;	// clrf	PORTB


	OPTION_REG = 0b00001000;
    //   	       0-------  NOT RBPU: 0 = PORTB pull-ups are enabled by individual port latch values
    //       	   -0------  INTEDG: 0 = Interrupt on rising edge of RB0/INT pin
    //   	       --0-----  T0CS: 1 = Transition on GP2/T0CKI pin0=output,
    //    	       ---0----  T0SE: 1 = Increment on high-to-low transition on /T0CKI pin not used, MCLR and reset
    //     		   ----1---  PSA: 1 = Prescaler is assigned to the WDT
    //   	       -----000  PS2:PS0: 111= 1:128 prescaler

	LED = 0;
	while(1)
	{
		LED = 1;  // LED ON
		__delay_ms(100);// delay for 100 milliseconds
		CLRWDT();
	    LED = 0;  // LED OFF
	    __delay_ms(100);// delay for 100 milliseconds
	}
}