/******************************************************************************
 Name:		LEDblink
 Title:    	Beginner uses ATMEGA8
 Author:   	F8EOZ Bernard Decaestecker http://f8eoz.com
 Date:     	11/11/2013 V1.0
 Software: 	AVR-GCC 4.3.3 
 Hardware: 	Tested with ATmega8 at 1Mhz
			Flashed by USBtinyISP
 Description:
 Blinking one LED fast or slow with use of push button. 
 
*******************************************************************************/
#include <avr/io.h>
#include <avr/io.h>
#include <util/delay.h>

/*LED */
#define LED_DDR DDRB //Data Direction Register of PORT B
#define LED_PORT PORTB //LED output connected to PORTB
#define LED0 PINB0 //LED0 bit number, LED0 connected to Pin0 of PORTB
/* Button*/
#define BUTTON1_DDR DDRB //Data Direction Register of PORT B
#define BUTTON1_PORT PORTB //BUTTON output connected to PORTB
#define BUTTON1_PIN PINB //BUTTON input connected to PINB
#define BUTTON1 PINB1 //BUTTON1 bit number, BUTTON1 connected to Pin1 of PORTB


  int main(void)
  //
  {
	/* To set a bit in LED_DDR, OR the value with the bit value mask. */
	LED_DDR |= (1 << LED0); //OR: Set bit 0 of LED_DDR to 1 for output, others not change 
	/* To clear a bit in BUTTON1_DDR, AND the value with the NOT bit value mask. */
	BUTTON1_DDR &= ~(1 << BUTTON1); //Clear bit 1 of BUTTON1_DDR for input, others not change 		
	BUTTON1_PORT |= (1 << BUTTON1); //Set button off = 5V
	
	  while(1)
	  {
		/* To toggle a bit in LED_PORT, XOR the value with the bit value mask.*/
 		LED_PORT ^= (1 << LED0); //XOR: Toggle bit 0 of LED_PORT = 5V->0V, 0V->5V
		/* Toggle speed blinking */
		if (bit_is_clear(BUTTON1_PIN, BUTTON1))
		{ //button pressed
			_delay_ms(10); //fast blinking: Wait for 10ms
		}
		else
		{ //button not pressed
			_delay_ms(100); //slow blinking (initial value): Wait for 100ms
		}
	  }
	
	
  }

