<?php 
	if (function_exists('register_sidebar') )
		// est utilis quand on ajoute un widget
		register_sidebar(array(
			'before_widget' => '<li id="%1$s" class="widget %2$s">',
			'after_widget' => '</li>',
			'before_title' => '<h2 class="widgettitle">',
			'after_title' => '</h2>',
			)
		); // ici tous les paramtres ont la valeur par dfaut
	// end register_sidebar
?> 
<?php
// Une itration de la boucle de traitement des commentaires wp_list_comments
// Affiche le commentaire, ping, trackback, ses mta-donnes, la possibilt de modifier et d'y rpondre
// $comment = commentaire affich
// $args contient les arguments par dfaut de la fonction wp_list_comments
// $depth = niveau de profondeur du commentaire affich = 1  n
// Voir tableau de bord, options de discussion Enable threaded (nested) comments
function mytheme_comment($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	$GLOBALS['comment_depth'] = $depth;
	?>
	<li id="comment-<?php comment_ID() ?>" <?php comment_class() ?>>
		<div>
			<span class="comment-author">
				<cite class="fn"><?php comment_author_link() ?></cite> &middot;		
			</span>
			<span class="comment-meta">
				<!--La o __() (2 underscores) traduit une chane de caractres en utilisant le gettext PHP.
				Le 1er paramtre est le string  traduire, 
				le second, appel le domain, dit  WordPress o se trouve la traduction.
				Il est ainsi possible de fournir un fichier.po qui contient la traduction du thme-->
				<?php printf(__('<a href="%3$s" title="Lien vers ce commentaire">%1$s &agrave; %2$s </a>', 'montheme'),
								get_comment_date('l j F Y'),
								get_comment_time('H:m:s'),
								'#comment-' . get_comment_ID() ); ?> &nbsp;&nbsp;
				<?php edit_comment_link(__('(Modifier)', 'montheme'), ''); ?>
			</span>
		</div>
		<div>
			<?php if ($comment->comment_approved == '0') :?>
				<span class="comment-unapproved">
					<?php _e("En attente de mod&eacute;ration.", 'montheme'); ?>
				</span>
			<?php else : comment_text(); // le commentaire est affich s'il est approuv?>
			<?php endif ?>	<!-- fin comment_approved -->
        </div>
			<div class="reply">
				<?php if(get_comment_type() == 'comment') : //rponse possible au commentaire?>
					<?php // lien pour la rponse
					comment_reply_link(array_merge($args, array(
						'reply_text' => __('R&eacute;pondre','montheme'), 
						'login_text' => __('Connexion pour r&eacute;pondre.','montheme'),
						'depth' => $depth,
						'before' => '<div class="comment-reply-link">', 
						'after' => '</div>'
						 )));?>
				<?php else : ?>
					<?php comment_type(); ?>
				<?php endif ?><!-- comment_type() == 'comment' -->
			</div><!--end class="reply-->	
	</li><!--end li id="comment-"-->
<?php } // end mytheme_comment
    
?>

<?php //add_action( 'shutdown', 'print_them_globals' );
function print_them_globals() {

    ksort( $GLOBALS );
    echo '<ol>';
    echo '<li>'. implode( '</li><li>', array_keys( $GLOBALS ) ) . '</li>';
    echo '</ol>';
}
?>