<?php
// Do not delete these lines
if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
    die ( __('Veuillez ne pas passer directement par cette page. Merci!', 'montheme') );

/* Rcupre le rglage de l'option de discussion du tableau de bord:
Lauteur dun commentaire doit renseigner son nom et son e-mail 
1 : Yes (default) 
0 : No 
Data type: Integer */
$requireoption = get_option('require_name_email');
?>

<div id="comments">
	<?php 
/* S'il y a des commentaires les afficher! */                                             
	if ( have_comments() ) : 
		// Compte le nombre de commentaires et trackbacks (ou pings)
		$ping_count = $comment_count = 0;  // init compteur de pings et de commentaires
		// compte les commentaires et les pings
		foreach ( $comments as $comment ) get_comment_type() == "comment" ? ++$comment_count : ++$ping_count; 
		?>
		<!-- affiche le nombre de commentaires -->
		<h3>
			<?php if ( $comment_count != 0 || $ping_count != 0) : ?>
				<?php printf($comment_count == 0 ? __('Aucun Commentaire', 'montheme') : 
					($comment_count == 1 ? __('1 Commentaire', 'montheme') : 
						__('%d Commentaires', 'montheme')), $comment_count) ?>
			<?php endif; ?>       
			<?php if ( $ping_count != 0 ) : ?>
				&middot;
				<?php printf($ping_count == 1 ? __('1 R&eacute;trolien', 'montheme') : 
							__('%d R&eacute;troliens', 'montheme'), $ping_count) ?>
			<?php endif; ?>       
		</h3>
		<div style="clear:both"></div>
		<!-- Une liste classe des commentaires, voir custom_comments() dans functions.php -->                         
		<ol class="commentlist"> <!-- type=comment filtre les commentaires -->
			<?php wp_list_comments('type=all&callback=mytheme_comment'); ?>
		</ol>
		<?php
		/* S'il y a trop de commentaires placer les liens de navigation  */                                      
		$total_pages = get_comment_pages_count(); 
		if ( $total_pages > 1 ) : ?>
			<div class="navigation" style="clear:both">
				<div class="alignleft"><?php previous_comments_link(__('&laquo; Commentaires plus anciens', 'montheme')) ?></div>
				<div class="alignright"><?php next_comments_link(__('commentaires plus r&eacute;cents &raquo;', 'montheme')) ?></div>
			</div>
		<?php endif; ?>       
		<div style="clear:both"></div>
		
	<?php else : // pas de commentaires ?>
		<?php if ( $post->comment_status == 'open') : ?>
			<!-- commentaires ouverts -->
		 <?php else : // comments are closed ?>
			<!-- commentaires ferms-->
			<p class="nocomments"><?php _e('Commentaires ferm&eacute;s.', 'montheme'); ?></p>
		<?php endif; /* if ( open ) */ ?>

	<?php endif; // have_comments() ?>

	<?php
	/* Si les commentaires sont ouvert, afficher le bloc de saisie d'un commentaire */ 
	if ( $post->comment_status == 'open' ) : ?>
		<div id="respond">
			<b><?php comment_form_title( __('Publier un commentaire', 'montheme'), __('Publier un commentaire &agrave; %s', 'montheme') ); ?>
			</b>&nbsp&nbsp&nbsp<?php cancel_comment_reply_link( __('(Annuler)', 'montheme')); ?>
				
			<?php if ( get_option('comment_registration') && !$user_ID ) : ?>
				<p><?php _e('Vous devez &ecirc;tre', 'montheme'); ?> <a href="<?php echo get_option('siteurl'); ?>/wp-login.php?redirect_to=<?php echo urlencode(get_permalink()); ?>"><?php _e('connect&eacute;', 'montheme'); ?></a> <?php _e('pour publier un commentaire.', 'montheme'); ?></p>
			<?php else : ?>
				<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">

					<?php if ( $user_ID ) : ?>
						<p><?php _e('Connect&eacute; comme', 'montheme'); ?> 
						<a href="<?php echo get_option('siteurl'); ?>/wp-admin/profile.php"><?php echo $user_identity; ?></a>
						| <a href="<?php echo wp_logout_url(get_permalink()); ?>" title="<?php _e('Logout', 'montheme'); ?>"><?php _e('D&eacute;connexion &raquo;', 'montheme'); ?></a>
						</p>
					<?php else : ?>
						<p><input type="text" name="author" id="author" value="<?php echo $comment_author; ?>" size="22" tabindex="1" />
							<label for="author"><small><?php _e('Nom', 'montheme'); ?> <?php if ($requireoption) _e('(requis)', 'montheme'); ?></small></label>
						</p>
						<p><input type="text" name="email" id="email" value="<?php echo $comment_author_email; ?>" size="22" tabindex="2" />
							<label for="email"><small><?php _e('Mail (non publi&eacute;)', 'montheme'); ?> <?php if ($requireoption) _e('(requis)', 'montheme'); ?></small></label>
						</p>
						<p><input type="text" name="url" id="url" value="<?php echo $comment_author_url; ?>" size="22" tabindex="3" />
							<label for="url"><small><?php _e('Site web', 'montheme'); ?></small></label>
						</p>
					<?php endif /* if ( $user_ID ) */ ?>
				<!--<p><small><strong>XHTML:</strong> You can use these tags: <code><?php echo allowed_tags(); ?></code></small></p>-->

					<p><textarea name="comment" id="comment" cols="100%" rows="10" tabindex="4"></textarea></p>
					<p><input name="submit" type="submit" id="submit" tabindex="5" value="<?php _e('Valider', 'montheme'); ?>" />
						<?php comment_id_fields(); ?> <!--Gnre 2 champs cachs: comment_post_ID et comment_parent -->
					</p>
				<?php do_action('comment_form', $post->ID); ?>

			</form><!-- #commentform --> 
		
		<?php endif; // If registration required and not logged in ?>
		</div><!-- #respond -->
	<?php endif; // if ( 'open' == $post->comment_status ) ?>
</div><!-- #comments -->

